#ifdef PRECOMPILEDHEADERS
	#include "Tactical All.h"
#else
	#include "sgp.h"
	#include "Debug Control.h"
	#include "expat.h"
	#include "XML.h"
	#include "Interface.h"
	#include "legion cfg.h"
	#include "Soldier Profile.h"
#endif
#ifdef LEGION2
struct
{
	PARSE_STAGE	curElement;

	CHAR8		szCharData[MAX_CHAR_DATA_LENGTH+1];
	MERC_NAMES_VALUES	curMercNames;
	MERC_NAMES_VALUES *	curArray;

	UINT32			maxArraySize;
	UINT32			curIndex;
	UINT32			currentDepth;
	UINT32			maxReadDepth;
	//CHAR16 gzMercNames[MAX_ENEMY_NAMES_CHARS];
}
typedef mercNamesParseData;

BOOLEAN MercName_TextOnly;

static void XMLCALL
mercNamesStartElementHandle(void *userData, const XML_Char *name, const XML_Char **atts)
{
	mercNamesParseData * pData = (mercNamesParseData *)userData;

	if(pData->currentDepth <= pData->maxReadDepth) //are we reading this element?
	{
		if(strcmp(name, "MERC_NAMES") == 0 && pData->curElement == ELEMENT_NONE)
		{
			pData->curElement = ELEMENT_LIST;

			pData->maxReadDepth++; //we are not skipping this element
		}
		else if(strcmp(name, "NAME") == 0 && pData->curElement == ELEMENT_LIST)
		{
			pData->curElement = ELEMENT;

			pData->maxReadDepth++; //we are not skipping this element
		}
		else if(pData->curElement == ELEMENT &&
			   (strcmp(name, "uiIndex") == 0 ||
				strcmp(name, "ProfileID") == 0 ||
				strcmp(name, "szName") == 0 ||
				strcmp(name, "szNickName") == 0 ||
				strcmp(name, "szAltName") == 0 ||
				strcmp(name, "szAltNickName") == 0 
				))
		{
			pData->curElement = ELEMENT_PROPERTY;

			pData->maxReadDepth++; //we are not skipping this element
		}

		pData->szCharData[0] = '\0';
	}

	pData->currentDepth++;

}

static void XMLCALL
mercNamesCharacterDataHandle(void *userData, const XML_Char *str, int len)
{
	mercNamesParseData * pData = (mercNamesParseData *)userData;

	if( (pData->currentDepth <= pData->maxReadDepth) &&
		(strlen(pData->szCharData) < MAX_CHAR_DATA_LENGTH)
	){
		strncat(pData->szCharData,str,__min((unsigned int)len,MAX_CHAR_DATA_LENGTH-strlen(pData->szCharData)));
	}
}


static void XMLCALL
mercNamesEndElementHandle(void *userData, const XML_Char *name)
{
	mercNamesParseData * pData = (mercNamesParseData *)userData;

	if(pData->currentDepth <= pData->maxReadDepth) 
	{
		if(strcmp(name, "MERC_NAMES") == 0)
		{
			pData->curElement = ELEMENT_NONE;
		}
		else if(strcmp(name, "NAME") == 0)
		{
			pData->curElement = ELEMENT_LIST;	
			
			if (!MercName_TextOnly)
				{
					if ( pData->curMercNames.ProfileID > -1 )
					{
					wcscpy(MercName[pData->curMercNames.uiIndex].szName, pData->curMercNames.szName);
					wcscpy(MercName[pData->curMercNames.uiIndex].szNickName, pData->curMercNames.szNickName);
					
					wcscpy(MercName[pData->curMercNames.uiIndex].szAltName, pData->curMercNames.szAltName);
					wcscpy(MercName[pData->curMercNames.uiIndex].szAltNickName, pData->curMercNames.szAltNickName);
					
					MercName[pData->curMercNames.uiIndex].ProfileID = pData->curMercNames.ProfileID;
					
					//wcscpy(gMercProfiles[ pData->curMercNames.ProfileID ].zName, MercName[pData->curMercNames.uiIndex].szName);
					//wcscpy(gMercProfiles[ pData->curMercNames.ProfileID ].zNickname, MercName[pData->curMercNames.uiIndex].szNickName);
					}
				}
				else
				{
					if ( pData->curMercNames.ProfileID > -1 )
					{
					wcscpy(MercName[pData->curMercNames.uiIndex].szName, pData->curMercNames.szName);
					wcscpy(MercName[pData->curMercNames.uiIndex].szNickName, pData->curMercNames.szNickName);
					
					wcscpy(MercName[pData->curMercNames.uiIndex].szAltName, pData->curMercNames.szAltName);
					wcscpy(MercName[pData->curMercNames.uiIndex].szAltNickName, pData->curMercNames.szAltNickName);
					
					//wcscpy(gMercProfiles[ pData->curMercNames.ProfileID ].zName, MercName[pData->curMercNames.uiIndex].szName);
					//wcscpy(gMercProfiles[ pData->curMercNames.ProfileID ].zNickname, MercName[pData->curMercNames.uiIndex].szNickName);
					}
				}		
		
		}
		else if(strcmp(name, "uiIndex") == 0)
		{
			pData->curElement = ELEMENT;
			pData->curMercNames.uiIndex	= (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "ProfileID") == 0 )
		{
			pData->curElement = ELEMENT;

			pData->curMercNames.ProfileID	= (INT16) atol(pData->szCharData);		
		}
		else if(strcmp(name, "szName") == 0 )
		{
			pData->curElement = ELEMENT;

			MultiByteToWideChar( CP_UTF8, 0, pData->szCharData, -1, pData->curMercNames.szName, sizeof(pData->curMercNames.szName)/sizeof(pData->curMercNames.szName[0]) );
			pData->curMercNames.szName[sizeof(pData->curMercNames.szName)/sizeof(pData->curMercNames.szName[0]) - 1] = '\0';
		}
		else if(strcmp(name, "szNickName") == 0 )
		{
			pData->curElement = ELEMENT;

			MultiByteToWideChar( CP_UTF8, 0, pData->szCharData, -1, pData->curMercNames.szNickName, sizeof(pData->curMercNames.szNickName)/sizeof(pData->curMercNames.szNickName[0]) );
			pData->curMercNames.szNickName[sizeof(pData->curMercNames.szNickName)/sizeof(pData->curMercNames.szNickName[0]) - 1] = '\0';
		}
		else if(strcmp(name, "szAltName") == 0 )
		{
			pData->curElement = ELEMENT;

			MultiByteToWideChar( CP_UTF8, 0, pData->szCharData, -1, pData->curMercNames.szAltName, sizeof(pData->curMercNames.szAltName)/sizeof(pData->curMercNames.szAltName[0]) );
			pData->curMercNames.szAltName[sizeof(pData->curMercNames.szAltName)/sizeof(pData->curMercNames.szAltName[0]) - 1] = '\0';
		}
		else if(strcmp(name, "szAltNickName") == 0 )
		{
			pData->curElement = ELEMENT;

			MultiByteToWideChar( CP_UTF8, 0, pData->szCharData, -1, pData->curMercNames.szAltNickName, sizeof(pData->curMercNames.szAltNickName)/sizeof(pData->curMercNames.szAltNickName[0]) );
			pData->curMercNames.szAltNickName[sizeof(pData->curMercNames.szAltNickName)/sizeof(pData->curMercNames.szAltNickName[0]) - 1] = '\0';
		}
		pData->maxReadDepth--;
	}
	pData->currentDepth--;
}




BOOLEAN ReadInMercNames(STR fileName, BOOLEAN localizedVersion)
{
	HWFILE		hFile;
	UINT32		uiBytesRead;
	UINT32		uiFSize;
	CHAR8 *		lpcBuffer;
	XML_Parser	parser = XML_ParserCreate(NULL);

	mercNamesParseData pData;

	DebugMsg(TOPIC_JA2, DBG_LEVEL_3, "Loading MercNames.xml" );

	MercName_TextOnly = localizedVersion;
	
	// Open file
	hFile = FileOpen( fileName, FILE_ACCESS_READ, FALSE );
	if ( !hFile )
		return( localizedVersion );

	uiFSize = FileGetSize(hFile);
	lpcBuffer = (CHAR8 *) MemAlloc(uiFSize+1);

	//Read in block
	if ( !FileRead( hFile, lpcBuffer, uiFSize, &uiBytesRead ) )
	{
		MemFree(lpcBuffer);
		return( FALSE );
	}

	lpcBuffer[uiFSize] = 0; //add a null terminator

	FileClose( hFile );


	XML_SetElementHandler(parser, mercNamesStartElementHandle, mercNamesEndElementHandle);
	XML_SetCharacterDataHandler(parser, mercNamesCharacterDataHandle);


	memset(&pData,0,sizeof(pData));
	XML_SetUserData(parser, &pData);


	if(!XML_Parse(parser, lpcBuffer, uiFSize, TRUE))
	{
		CHAR8 errorBuf[511];

		sprintf(errorBuf, "XML Parser Error in MercNames.xml: %s at line %d", XML_ErrorString(XML_GetErrorCode(parser)), XML_GetCurrentLineNumber(parser));
		LiveMessage(errorBuf);

		MemFree(lpcBuffer);
		return FALSE;
	}

	MemFree(lpcBuffer);


	XML_ParserFree(parser);


	return( TRUE );
}
#endif